program Listing7;

uses
  RTTI, System.SysUtils, TypInfo, System.Classes, System.StrUtils, System.Generics.Collections;

type
  TRozszerzonyInterfejsWirtualny<T: IInvokable> = class(TVirtualInterface)
  protected
    procedure WywołajMetodę(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue);
    procedure WywołajMetodęImpl(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue); virtual; abstract;
  public
    constructor Create;
  end;

constructor TRozszerzonyInterfejsWirtualny<T>.Create;
begin
  inherited Create(TypeInfo(T), WywołajMetodę);
end;

procedure TRozszerzonyInterfejsWirtualny<T>.WywołajMetodę(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue);
begin
  WywołajMetodęImpl(Metoda, Argumenty, Wynik);
end;

type
  IProstaAtrapa<T> = interface
    ['{6AA7C2F0-E62F-497B-9A77-04D6F369A288}']
    function WywoływanyInterfejs: T;
  end;

  TProstaAtrapa<T: IInvokable> = class(TRozszerzonyInterfejsWirtualny<T>, IProstaAtrapa<T>)
  protected
    procedure WywołajMetodęImpl(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue); override;
  public
    function WywoływanyInterfejs: T;
  end;

procedure TProstaAtrapa<T>.WywołajMetodęImpl(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue);
begin
// Ponieważ jest to atrapa, nie można nic robić!
end;

function TProstaAtrapa<T>.WywoływanyInterfejs: T;
var
  pInfo : PTypeInfo;
begin
  pInfo := TypeInfo(T);
  if QueryInterface(GetTypeData(pInfo).Guid, Result) <> 0 then
  begin
    raise Exception.CreateFmt('Niestety, TProstaAtrapa<T> nie może zmienić typu %s na interfejs', [string(pInfo.Name)]);
  end;
end;

type
  IProstaImitacja<T> = interface(IProstaAtrapa<T>)
    ['{9619542B-A53B-4C0C-B915-45ED140E6479}']
    procedure DodajWynik(aNazwaMetody: string; aWynik: TValue);
  end;

  TProstaImitacja<T: IInvokable> = class(TProstaAtrapa<T>, IProstaImitacja<T>)
  private
    FWyniki: TDictionary<string, TValue>;
  protected
    procedure WywołajMetodęImpl(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue); override;
  public
    constructor Create;
    destructor Destroy; override;
    procedure DodajWynik(aNazwaMetody: string; aWynik: TValue);
  end;

constructor TProstaImitacja<T>.Create;
begin
  FWyniki := TDictionary<string, TValue>.Create;
end;

destructor TProstaImitacja<T>.Destroy;
begin
  FWyniki.Free;
end;

procedure TProstaImitacja<T>.DodajWynik(aNazwaMetody: string; aWynik: TValue);
begin
  FWyniki.Add(aNazwaMetody, aWynik);
end;

procedure TProstaImitacja<T>.WywołajMetodęImpl(Metoda: TRttiMethod; const Argumenty: TArray<TValue>; out Wynik: TValue);
begin
  Wynik := FWyniki[Metoda.Name];
end;

type
  IPrzydatnyInterfejs = interface(IInvokable)
    ['{16F01BF0-961F-4461-AEBE-B1ACB8D3F0F4}']
    procedure Witaj;
    function TekstWstecz(aTekst: string): string;
    function Iloczyn(x, y: integer): integer;
  end;

var
  ProstaImitacja: TProstaImitacja<IPrzydatnyInterfejs>;
begin
  WriteLn('Interfejs IPrzydatnyInterfejs z interfejsem IProstaImitacja');
  ProstaImitacja := TProstaImitacja<IPrzydatnyInterfejs>.Create;
  ProstaImitacja.DodajWynik('Iloczyn', 99);
  ProstaImitacja.DodajWynik('TekstWstecz', 'W rzeczywistości to działa');
  WriteLn(ProstaImitacja.WywoływanyInterfejs.Iloczyn(6, 7));
  WriteLn(ProstaImitacja.WywoływanyInterfejs.TekstWstecz('Argumenty nie mają znaczenia'));
  WriteLn;
  ReadLn;
end.

